package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTagsRequest(
    resourceId: NonEmptyString,
    tagKeys: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest = {
    import DeleteTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest
      .builder()
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DeleteTagsRequest.ReadOnly =
    zio.aws.workspaces.model.DeleteTagsRequest.wrap(buildAwsValue())
}
object DeleteTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DeleteTagsRequest =
      zio.aws.workspaces.model.DeleteTagsRequest(resourceId, tagKeys)
    def resourceId: NonEmptyString
    def tagKeys: List[NonEmptyString]
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getTagKeys: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest
  ) extends zio.aws.workspaces.model.DeleteTagsRequest.ReadOnly {
    override val resourceId: NonEmptyString =
      zio.aws.workspaces.model.primitives.NonEmptyString(impl.resourceId())
    override val tagKeys: List[NonEmptyString] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest
  ): zio.aws.workspaces.model.DeleteTagsRequest.ReadOnly = new Wrapper(impl)
}
