package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait DeletableCertificateBasedAuthProperty {
  def unwrap: software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty
}
object DeletableCertificateBasedAuthProperty {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty
  ): zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty =
    value match {
      case software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty.CERTIFICATE_BASED_AUTH_PROPERTIES_CERTIFICATE_AUTHORITY_ARN =>
        val r = CERTIFICATE_BASED_AUTH_PROPERTIES_CERTIFICATE_AUTHORITY_ARN
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty =
      software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty.UNKNOWN_TO_SDK_VERSION
  }
  case object CERTIFICATE_BASED_AUTH_PROPERTIES_CERTIFICATE_AUTHORITY_ARN
      extends zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty =
      software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty.CERTIFICATE_BASED_AUTH_PROPERTIES_CERTIFICATE_AUTHORITY_ARN
  }
}
