package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{BooleanObject, AwsAccount}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConnectionAliasPermission(
    sharedAccountId: AwsAccount,
    allowAssociation: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ConnectionAliasPermission = {
    import ConnectionAliasPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ConnectionAliasPermission
      .builder()
      .sharedAccountId(AwsAccount.unwrap(sharedAccountId): java.lang.String)
      .allowAssociation(allowAssociation: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly =
    zio.aws.workspaces.model.ConnectionAliasPermission.wrap(buildAwsValue())
}
object ConnectionAliasPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ConnectionAliasPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ConnectionAliasPermission =
      zio.aws.workspaces.model
        .ConnectionAliasPermission(sharedAccountId, allowAssociation)
    def sharedAccountId: AwsAccount
    def allowAssociation: BooleanObject
    def getSharedAccountId: ZIO[Any, Nothing, AwsAccount] =
      ZIO.succeed(sharedAccountId)
    def getAllowAssociation: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(allowAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAliasPermission
  ) extends zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly {
    override val sharedAccountId: AwsAccount =
      zio.aws.workspaces.model.primitives.AwsAccount(impl.sharedAccountId())
    override val allowAssociation: BooleanObject =
      impl.allowAssociation(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAliasPermission
  ): zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly = new Wrapper(
    impl
  )
}
