package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait SamlStatusEnum {
  def unwrap: software.amazon.awssdk.services.workspaces.model.SamlStatusEnum
}
object SamlStatusEnum {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.SamlStatusEnum
  ): zio.aws.workspaces.model.SamlStatusEnum = value match {
    case software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK =>
      val r = ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.SamlStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.SamlStatusEnum =
      software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.workspaces.model.SamlStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.SamlStatusEnum =
      software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.DISABLED
  }
  case object ENABLED extends zio.aws.workspaces.model.SamlStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.SamlStatusEnum =
      software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.ENABLED
  }
  case object ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK
      extends zio.aws.workspaces.model.SamlStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.SamlStatusEnum =
      software.amazon.awssdk.services.workspaces.model.SamlStatusEnum.ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK
  }
}
