package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait ReconnectEnum {
  def unwrap: software.amazon.awssdk.services.workspaces.model.ReconnectEnum
}
object ReconnectEnum {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ReconnectEnum
  ): zio.aws.workspaces.model.ReconnectEnum = value match {
    case software.amazon.awssdk.services.workspaces.model.ReconnectEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ReconnectEnum.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.workspaces.model.ReconnectEnum.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.ReconnectEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ReconnectEnum =
      software.amazon.awssdk.services.workspaces.model.ReconnectEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.workspaces.model.ReconnectEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ReconnectEnum =
      software.amazon.awssdk.services.workspaces.model.ReconnectEnum.ENABLED
  }
  case object DISABLED extends zio.aws.workspaces.model.ReconnectEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ReconnectEnum =
      software.amazon.awssdk.services.workspaces.model.ReconnectEnum.DISABLED
  }
}
