package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClientPropertiesResponse(
    clientPropertiesList: Optional[
      Iterable[zio.aws.workspaces.model.ClientPropertiesResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse = {
    import DescribeClientPropertiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse
      .builder()
      .optionallyWith(
        clientPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clientPropertiesList)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeClientPropertiesResponse
      .wrap(buildAwsValue())
}
object DescribeClientPropertiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeClientPropertiesResponse =
      zio.aws.workspaces.model.DescribeClientPropertiesResponse(
        clientPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientPropertiesList: Optional[
      List[zio.aws.workspaces.model.ClientPropertiesResult.ReadOnly]
    ]
    def getClientPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ClientPropertiesResult.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clientPropertiesList", clientPropertiesList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse
  ) extends zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly {
    override val clientPropertiesList: Optional[
      List[zio.aws.workspaces.model.ClientPropertiesResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clientPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.ClientPropertiesResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse
  ): zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly =
    new Wrapper(impl)
}
