package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeClientBrandingRequest(resourceId: DirectoryId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest = {
    import DescribeClientBrandingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeClientBrandingRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeClientBrandingRequest.wrap(buildAwsValue())
}
object DescribeClientBrandingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeClientBrandingRequest =
      zio.aws.workspaces.model.DescribeClientBrandingRequest(resourceId)
    def resourceId: DirectoryId
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest
  ) extends zio.aws.workspaces.model.DescribeClientBrandingRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest
  ): zio.aws.workspaces.model.DescribeClientBrandingRequest.ReadOnly =
    new Wrapper(impl)
}
