package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStandbyWorkspacesResponse(
    failedStandbyRequests: Optional[
      Iterable[zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest]
    ] = Optional.Absent,
    pendingStandbyRequests: Optional[
      Iterable[zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse = {
    import CreateStandbyWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse
      .builder()
      .optionallyWith(
        failedStandbyRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedStandbyRequests)
      .optionallyWith(
        pendingStandbyRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingStandbyRequests)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateStandbyWorkspacesResponse.ReadOnly =
    zio.aws.workspaces.model.CreateStandbyWorkspacesResponse
      .wrap(buildAwsValue())
}
object CreateStandbyWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateStandbyWorkspacesResponse =
      zio.aws.workspaces.model.CreateStandbyWorkspacesResponse(
        failedStandbyRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingStandbyRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedStandbyRequests: Optional[List[
      zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest.ReadOnly
    ]]
    def pendingStandbyRequests: Optional[List[
      zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest.ReadOnly
    ]]
    def getFailedStandbyRequests: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("failedStandbyRequests", failedStandbyRequests)
    def getPendingStandbyRequests: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingStandbyRequests",
      pendingStandbyRequests
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse
  ) extends zio.aws.workspaces.model.CreateStandbyWorkspacesResponse.ReadOnly {
    override val failedStandbyRequests: Optional[List[
      zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.failedStandbyRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest
            .wrap(item)
        }.toList
      )
    override val pendingStandbyRequests: Optional[List[
      zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingStandbyRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse
  ): zio.aws.workspaces.model.CreateStandbyWorkspacesResponse.ReadOnly =
    new Wrapper(impl)
}
