package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.Region
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateStandbyWorkspacesRequest(
    primaryRegion: Region,
    standbyWorkspaces: Iterable[zio.aws.workspaces.model.StandbyWorkspace]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest = {
    import CreateStandbyWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest
      .builder()
      .primaryRegion(Region.unwrap(primaryRegion): java.lang.String)
      .standbyWorkspaces(standbyWorkspaces.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateStandbyWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.CreateStandbyWorkspacesRequest
      .wrap(buildAwsValue())
}
object CreateStandbyWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateStandbyWorkspacesRequest =
      zio.aws.workspaces.model.CreateStandbyWorkspacesRequest(
        primaryRegion,
        standbyWorkspaces.map { item =>
          item.asEditable
        }
      )
    def primaryRegion: Region
    def standbyWorkspaces
        : List[zio.aws.workspaces.model.StandbyWorkspace.ReadOnly]
    def getPrimaryRegion: ZIO[Any, Nothing, Region] = ZIO.succeed(primaryRegion)
    def getStandbyWorkspaces: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.StandbyWorkspace.ReadOnly
    ]] = ZIO.succeed(standbyWorkspaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest
  ) extends zio.aws.workspaces.model.CreateStandbyWorkspacesRequest.ReadOnly {
    override val primaryRegion: Region =
      zio.aws.workspaces.model.primitives.Region(impl.primaryRegion())
    override val standbyWorkspaces
        : List[zio.aws.workspaces.model.StandbyWorkspace.ReadOnly] = impl
      .standbyWorkspaces()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.StandbyWorkspace.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest
  ): zio.aws.workspaces.model.CreateStandbyWorkspacesRequest.ReadOnly =
    new Wrapper(impl)
}
