package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.CertificateAuthorityArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CertificateBasedAuthProperties(
    status: Optional[zio.aws.workspaces.model.CertificateBasedAuthStatusEnum] =
      Optional.Absent,
    certificateAuthorityArn: Optional[CertificateAuthorityArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CertificateBasedAuthProperties = {
    import CertificateBasedAuthProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CertificateBasedAuthProperties
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          CertificateAuthorityArn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CertificateBasedAuthProperties.ReadOnly =
    zio.aws.workspaces.model.CertificateBasedAuthProperties
      .wrap(buildAwsValue())
}
object CertificateBasedAuthProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CertificateBasedAuthProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CertificateBasedAuthProperties =
      zio.aws.workspaces.model.CertificateBasedAuthProperties(
        status.map(value => value),
        certificateAuthorityArn.map(value => value)
      )
    def status
        : Optional[zio.aws.workspaces.model.CertificateBasedAuthStatusEnum]
    def certificateAuthorityArn: Optional[CertificateAuthorityArn]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.CertificateBasedAuthStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getCertificateAuthorityArn
        : ZIO[Any, AwsError, CertificateAuthorityArn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CertificateBasedAuthProperties
  ) extends zio.aws.workspaces.model.CertificateBasedAuthProperties.ReadOnly {
    override val status
        : Optional[zio.aws.workspaces.model.CertificateBasedAuthStatusEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.workspaces.model.CertificateBasedAuthStatusEnum.wrap(value)
        )
    override val certificateAuthorityArn: Optional[CertificateAuthorityArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthorityArn())
        .map(value =>
          zio.aws.workspaces.model.primitives.CertificateAuthorityArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CertificateBasedAuthProperties
  ): zio.aws.workspaces.model.CertificateBasedAuthProperties.ReadOnly =
    new Wrapper(impl)
}
