package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait BundleType {
  def unwrap: software.amazon.awssdk.services.workspaces.model.BundleType
}
object BundleType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.BundleType
  ): zio.aws.workspaces.model.BundleType = value match {
    case software.amazon.awssdk.services.workspaces.model.BundleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.BundleType.REGULAR =>
      val r = REGULAR
      r
    case software.amazon.awssdk.services.workspaces.model.BundleType.STANDBY =>
      val r = STANDBY
      r
  }
  case object unknownToSdkVersion extends zio.aws.workspaces.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.BundleType =
      software.amazon.awssdk.services.workspaces.model.BundleType.UNKNOWN_TO_SDK_VERSION
  }
  case object REGULAR extends zio.aws.workspaces.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.BundleType =
      software.amazon.awssdk.services.workspaces.model.BundleType.REGULAR
  }
  case object STANDBY extends zio.aws.workspaces.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.BundleType =
      software.amazon.awssdk.services.workspaces.model.BundleType.STANDBY
  }
}
