package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait WorkspaceDirectoryState {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState
}
object WorkspaceDirectoryState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState
  ): zio.aws.workspaces.model.WorkspaceDirectoryState = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.REGISTERING =>
      val r = REGISTERING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.REGISTERED =>
      val r = REGISTERED
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.DEREGISTERING =>
      val r = DEREGISTERING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.DEREGISTERED =>
      val r = DEREGISTERED
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkspaceDirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.UNKNOWN_TO_SDK_VERSION
  }
  case object REGISTERING
      extends zio.aws.workspaces.model.WorkspaceDirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.REGISTERING
  }
  case object REGISTERED
      extends zio.aws.workspaces.model.WorkspaceDirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.REGISTERED
  }
  case object DEREGISTERING
      extends zio.aws.workspaces.model.WorkspaceDirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.DEREGISTERING
  }
  case object DEREGISTERED
      extends zio.aws.workspaces.model.WorkspaceDirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.DEREGISTERED
  }
  case object ERROR extends zio.aws.workspaces.model.WorkspaceDirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState.ERROR
  }
}
