package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait RunningMode {
  def unwrap: software.amazon.awssdk.services.workspaces.model.RunningMode
}
object RunningMode {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.RunningMode
  ): zio.aws.workspaces.model.RunningMode = value match {
    case software.amazon.awssdk.services.workspaces.model.RunningMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.RunningMode.AUTO_STOP =>
      val r = AUTO_STOP
      r
    case software.amazon.awssdk.services.workspaces.model.RunningMode.ALWAYS_ON =>
      val r = ALWAYS_ON
      r
  }
  case object unknownToSdkVersion extends zio.aws.workspaces.model.RunningMode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.RunningMode =
      software.amazon.awssdk.services.workspaces.model.RunningMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO_STOP extends zio.aws.workspaces.model.RunningMode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.RunningMode =
      software.amazon.awssdk.services.workspaces.model.RunningMode.AUTO_STOP
  }
  case object ALWAYS_ON extends zio.aws.workspaces.model.RunningMode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.RunningMode =
      software.amazon.awssdk.services.workspaces.model.RunningMode.ALWAYS_ON
  }
}
