package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RebuildWorkspacesRequest(
    rebuildWorkspaceRequests: Iterable[zio.aws.workspaces.model.RebuildRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest = {
    import RebuildWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest
      .builder()
      .rebuildWorkspaceRequests(rebuildWorkspaceRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RebuildWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.RebuildWorkspacesRequest.wrap(buildAwsValue())
}
object RebuildWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RebuildWorkspacesRequest =
      zio.aws.workspaces.model
        .RebuildWorkspacesRequest(rebuildWorkspaceRequests.map { item =>
          item.asEditable
        })
    def rebuildWorkspaceRequests
        : List[zio.aws.workspaces.model.RebuildRequest.ReadOnly]
    def getRebuildWorkspaceRequests: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.RebuildRequest.ReadOnly
    ]] = ZIO.succeed(rebuildWorkspaceRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest
  ) extends zio.aws.workspaces.model.RebuildWorkspacesRequest.ReadOnly {
    override val rebuildWorkspaceRequests
        : List[zio.aws.workspaces.model.RebuildRequest.ReadOnly] = impl
      .rebuildWorkspaceRequests()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.RebuildRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest
  ): zio.aws.workspaces.model.RebuildWorkspacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
