package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RebootRequest(workspaceId: WorkspaceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RebootRequest = {
    import RebootRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RebootRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RebootRequest.ReadOnly =
    zio.aws.workspaces.model.RebootRequest.wrap(buildAwsValue())
}
object RebootRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RebootRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RebootRequest =
      zio.aws.workspaces.model.RebootRequest(workspaceId)
    def workspaceId: WorkspaceId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RebootRequest
  ) extends zio.aws.workspaces.model.RebootRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RebootRequest
  ): zio.aws.workspaces.model.RebootRequest.ReadOnly = new Wrapper(impl)
}
