package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.AwsAccount
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImagePermission(
    sharedAccountId: Optional[AwsAccount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ImagePermission = {
    import ImagePermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ImagePermission
      .builder()
      .optionallyWith(
        sharedAccountId.map(value => AwsAccount.unwrap(value): java.lang.String)
      )(_.sharedAccountId)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ImagePermission.ReadOnly =
    zio.aws.workspaces.model.ImagePermission.wrap(buildAwsValue())
}
object ImagePermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ImagePermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ImagePermission =
      zio.aws.workspaces.model
        .ImagePermission(sharedAccountId.map(value => value))
    def sharedAccountId: Optional[AwsAccount]
    def getSharedAccountId: ZIO[Any, AwsError, AwsAccount] =
      AwsError.unwrapOptionField("sharedAccountId", sharedAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ImagePermission
  ) extends zio.aws.workspaces.model.ImagePermission.ReadOnly {
    override val sharedAccountId: Optional[AwsAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.sharedAccountId())
      .map(value => zio.aws.workspaces.model.primitives.AwsAccount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ImagePermission
  ): zio.aws.workspaces.model.ImagePermission.ReadOnly = new Wrapper(impl)
}
