package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.ConnectionAliasId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateConnectionAliasRequest(
    aliasId: ConnectionAliasId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest = {
    import DisassociateConnectionAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest
      .builder()
      .aliasId(ConnectionAliasId.unwrap(aliasId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DisassociateConnectionAliasRequest.ReadOnly =
    zio.aws.workspaces.model.DisassociateConnectionAliasRequest
      .wrap(buildAwsValue())
}
object DisassociateConnectionAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DisassociateConnectionAliasRequest =
      zio.aws.workspaces.model.DisassociateConnectionAliasRequest(aliasId)
    def aliasId: ConnectionAliasId
    def getAliasId: ZIO[Any, Nothing, ConnectionAliasId] = ZIO.succeed(aliasId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest
  ) extends zio.aws.workspaces.model.DisassociateConnectionAliasRequest.ReadOnly {
    override val aliasId: ConnectionAliasId =
      zio.aws.workspaces.model.primitives.ConnectionAliasId(impl.aliasId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest
  ): zio.aws.workspaces.model.DisassociateConnectionAliasRequest.ReadOnly =
    new Wrapper(impl)
}
