package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateWorkspacesRequest(
    workspaces: Iterable[zio.aws.workspaces.model.WorkspaceRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest = {
    import CreateWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest
      .builder()
      .workspaces(workspaces.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.CreateWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.CreateWorkspacesRequest.wrap(buildAwsValue())
}
object CreateWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateWorkspacesRequest =
      zio.aws.workspaces.model.CreateWorkspacesRequest(workspaces.map { item =>
        item.asEditable
      })
    def workspaces: List[zio.aws.workspaces.model.WorkspaceRequest.ReadOnly]
    def getWorkspaces: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.WorkspaceRequest.ReadOnly
    ]] = ZIO.succeed(workspaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest
  ) extends zio.aws.workspaces.model.CreateWorkspacesRequest.ReadOnly {
    override val workspaces
        : List[zio.aws.workspaces.model.WorkspaceRequest.ReadOnly] = impl
      .workspaces()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.WorkspaceRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest
  ): zio.aws.workspaces.model.CreateWorkspacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
