package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  WorkspaceImageId,
  WorkspaceImageDescription,
  WorkspaceImageName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUpdatedWorkspaceImageRequest(
    name: WorkspaceImageName,
    description: WorkspaceImageDescription,
    sourceImageId: WorkspaceImageId,
    tags: Optional[Iterable[zio.aws.workspaces.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest = {
    import CreateUpdatedWorkspaceImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest
      .builder()
      .name(WorkspaceImageName.unwrap(name): java.lang.String)
      .description(
        WorkspaceImageDescription.unwrap(description): java.lang.String
      )
      .sourceImageId(WorkspaceImageId.unwrap(sourceImageId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateUpdatedWorkspaceImageRequest.ReadOnly =
    zio.aws.workspaces.model.CreateUpdatedWorkspaceImageRequest
      .wrap(buildAwsValue())
}
object CreateUpdatedWorkspaceImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.CreateUpdatedWorkspaceImageRequest =
      zio.aws.workspaces.model.CreateUpdatedWorkspaceImageRequest(
        name,
        description,
        sourceImageId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: WorkspaceImageName
    def description: WorkspaceImageDescription
    def sourceImageId: WorkspaceImageId
    def tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, WorkspaceImageName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, WorkspaceImageDescription] =
      ZIO.succeed(description)
    def getSourceImageId: ZIO[Any, Nothing, WorkspaceImageId] =
      ZIO.succeed(sourceImageId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest
  ) extends zio.aws.workspaces.model.CreateUpdatedWorkspaceImageRequest.ReadOnly {
    override val name: WorkspaceImageName =
      zio.aws.workspaces.model.primitives.WorkspaceImageName(impl.name())
    override val description: WorkspaceImageDescription =
      zio.aws.workspaces.model.primitives
        .WorkspaceImageDescription(impl.description())
    override val sourceImageId: WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId(impl.sourceImageId())
    override val tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest
  ): zio.aws.workspaces.model.CreateUpdatedWorkspaceImageRequest.ReadOnly =
    new Wrapper(impl)
}
