package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateTagsRequest(
    resourceId: NonEmptyString,
    tags: Iterable[zio.aws.workspaces.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateTagsRequest = {
    import CreateTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateTagsRequest
      .builder()
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.CreateTagsRequest.ReadOnly =
    zio.aws.workspaces.model.CreateTagsRequest.wrap(buildAwsValue())
}
object CreateTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateTagsRequest =
      zio.aws.workspaces.model.CreateTagsRequest(
        resourceId,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceId: NonEmptyString
    def tags: List[zio.aws.workspaces.model.Tag.ReadOnly]
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateTagsRequest
  ) extends zio.aws.workspaces.model.CreateTagsRequest.ReadOnly {
    override val resourceId: NonEmptyString =
      zio.aws.workspaces.model.primitives.NonEmptyString(impl.resourceId())
    override val tags: List[zio.aws.workspaces.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateTagsRequest
  ): zio.aws.workspaces.model.CreateTagsRequest.ReadOnly = new Wrapper(impl)
}
