package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{AddInUrl, AddInName, DirectoryId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateConnectClientAddInRequest(
    resourceId: DirectoryId,
    name: AddInName,
    url: AddInUrl
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest = {
    import CreateConnectClientAddInRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .name(AddInName.unwrap(name): java.lang.String)
      .url(AddInUrl.unwrap(url): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateConnectClientAddInRequest.ReadOnly =
    zio.aws.workspaces.model.CreateConnectClientAddInRequest
      .wrap(buildAwsValue())
}
object CreateConnectClientAddInRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateConnectClientAddInRequest =
      zio.aws.workspaces.model
        .CreateConnectClientAddInRequest(resourceId, name, url)
    def resourceId: DirectoryId
    def name: AddInName
    def url: AddInUrl
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getName: ZIO[Any, Nothing, AddInName] = ZIO.succeed(name)
    def getUrl: ZIO[Any, Nothing, AddInUrl] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest
  ) extends zio.aws.workspaces.model.CreateConnectClientAddInRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val name: AddInName =
      zio.aws.workspaces.model.primitives.AddInName(impl.name())
    override val url: AddInUrl =
      zio.aws.workspaces.model.primitives.AddInUrl(impl.url())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest
  ): zio.aws.workspaces.model.CreateConnectClientAddInRequest.ReadOnly =
    new Wrapper(impl)
}
