package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait ClientDeviceType {
  def unwrap: software.amazon.awssdk.services.workspaces.model.ClientDeviceType
}
object ClientDeviceType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ClientDeviceType
  ): zio.aws.workspaces.model.ClientDeviceType = value match {
    case software.amazon.awssdk.services.workspaces.model.ClientDeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_WINDOWS =>
      val r = DeviceTypeWindows
      r
    case software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_OSX =>
      val r = DeviceTypeOsx
      r
    case software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_ANDROID =>
      val r = DeviceTypeAndroid
      r
    case software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_IOS =>
      val r = DeviceTypeIos
      r
    case software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_LINUX =>
      val r = DeviceTypeLinux
      r
    case software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_WEB =>
      val r = DeviceTypeWeb
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.ClientDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ClientDeviceType =
      software.amazon.awssdk.services.workspaces.model.ClientDeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DeviceTypeWindows
      extends zio.aws.workspaces.model.ClientDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ClientDeviceType =
      software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_WINDOWS
  }
  case object DeviceTypeOsx extends zio.aws.workspaces.model.ClientDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ClientDeviceType =
      software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_OSX
  }
  case object DeviceTypeAndroid
      extends zio.aws.workspaces.model.ClientDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ClientDeviceType =
      software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_ANDROID
  }
  case object DeviceTypeIos extends zio.aws.workspaces.model.ClientDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ClientDeviceType =
      software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_IOS
  }
  case object DeviceTypeLinux
      extends zio.aws.workspaces.model.ClientDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ClientDeviceType =
      software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_LINUX
  }
  case object DeviceTypeWeb extends zio.aws.workspaces.model.ClientDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ClientDeviceType =
      software.amazon.awssdk.services.workspaces.model.ClientDeviceType.DEVICE_TYPE_WEB
  }
}
