package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{IpGroupDesc, IpGroupName, IpGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WorkspacesIpGroup(
    groupId: Optional[IpGroupId] = Optional.Absent,
    groupName: Optional[IpGroupName] = Optional.Absent,
    groupDesc: Optional[IpGroupDesc] = Optional.Absent,
    userRules: Optional[Iterable[zio.aws.workspaces.model.IpRuleItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup = {
    import WorkspacesIpGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
      .builder()
      .optionallyWith(
        groupId.map(value => IpGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value => IpGroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupDesc.map(value => IpGroupDesc.unwrap(value): java.lang.String)
      )(_.groupDesc)
      .optionallyWith(
        userRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userRules)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly =
    zio.aws.workspaces.model.WorkspacesIpGroup.wrap(buildAwsValue())
}
object WorkspacesIpGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspacesIpGroup =
      zio.aws.workspaces.model.WorkspacesIpGroup(
        groupId.map(value => value),
        groupName.map(value => value),
        groupDesc.map(value => value),
        userRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupId: Optional[IpGroupId]
    def groupName: Optional[IpGroupName]
    def groupDesc: Optional[IpGroupDesc]
    def userRules: Optional[List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]]
    def getGroupId: ZIO[Any, AwsError, IpGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, IpGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupDesc: ZIO[Any, AwsError, IpGroupDesc] =
      AwsError.unwrapOptionField("groupDesc", groupDesc)
    def getUserRules: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.IpRuleItem.ReadOnly
    ]] = AwsError.unwrapOptionField("userRules", userRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
  ) extends zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly {
    override val groupId: Optional[IpGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupId(value))
    override val groupName: Optional[IpGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupName(value))
    override val groupDesc: Optional[IpGroupDesc] = zio.aws.core.internal
      .optionalFromNullable(impl.groupDesc())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupDesc(value))
    override val userRules
        : Optional[List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.IpRuleItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
  ): zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly = new Wrapper(impl)
}
