package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartWorkspacesRequest(
    startWorkspaceRequests: Iterable[zio.aws.workspaces.model.StartRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest = {
    import StartWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest
      .builder()
      .startWorkspaceRequests(startWorkspaceRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.StartWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.StartWorkspacesRequest.wrap(buildAwsValue())
}
object StartWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.StartWorkspacesRequest =
      zio.aws.workspaces.model
        .StartWorkspacesRequest(startWorkspaceRequests.map { item =>
          item.asEditable
        })
    def startWorkspaceRequests
        : List[zio.aws.workspaces.model.StartRequest.ReadOnly]
    def getStartWorkspaceRequests: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.StartRequest.ReadOnly
    ]] = ZIO.succeed(startWorkspaceRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest
  ) extends zio.aws.workspaces.model.StartWorkspacesRequest.ReadOnly {
    override val startWorkspaceRequests
        : List[zio.aws.workspaces.model.StartRequest.ReadOnly] = impl
      .startWorkspaceRequests()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.StartRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest
  ): zio.aws.workspaces.model.StartWorkspacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
