package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModificationState(
    resource: Optional[zio.aws.workspaces.model.ModificationResourceEnum] =
      Optional.Absent,
    state: Optional[zio.aws.workspaces.model.ModificationStateEnum] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModificationState = {
    import ModificationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModificationState
      .builder()
      .optionallyWith(resource.map(value => value.unwrap))(_.resource)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ModificationState.ReadOnly =
    zio.aws.workspaces.model.ModificationState.wrap(buildAwsValue())
}
object ModificationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModificationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ModificationState =
      zio.aws.workspaces.model.ModificationState(
        resource.map(value => value),
        state.map(value => value)
      )
    def resource: Optional[zio.aws.workspaces.model.ModificationResourceEnum]
    def state: Optional[zio.aws.workspaces.model.ModificationStateEnum]
    def getResource: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.ModificationResourceEnum
    ] = AwsError.unwrapOptionField("resource", resource)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ModificationStateEnum] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModificationState
  ) extends zio.aws.workspaces.model.ModificationState.ReadOnly {
    override val resource
        : Optional[zio.aws.workspaces.model.ModificationResourceEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resource())
        .map(value =>
          zio.aws.workspaces.model.ModificationResourceEnum.wrap(value)
        )
    override val state
        : Optional[zio.aws.workspaces.model.ModificationStateEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.workspaces.model.ModificationStateEnum.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModificationState
  ): zio.aws.workspaces.model.ModificationState.ReadOnly = new Wrapper(impl)
}
