package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeWorkspaceSnapshotsResponse(
    rebuildSnapshots: Optional[Iterable[zio.aws.workspaces.model.Snapshot]] =
      Optional.Absent,
    restoreSnapshots: Optional[Iterable[zio.aws.workspaces.model.Snapshot]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse = {
    import DescribeWorkspaceSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse
      .builder()
      .optionallyWith(
        rebuildSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rebuildSnapshots)
      .optionallyWith(
        restoreSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.restoreSnapshots)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse =
      zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse(
        rebuildSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        restoreSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rebuildSnapshots
        : Optional[List[zio.aws.workspaces.model.Snapshot.ReadOnly]]
    def restoreSnapshots
        : Optional[List[zio.aws.workspaces.model.Snapshot.ReadOnly]]
    def getRebuildSnapshots
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Snapshot.ReadOnly]] =
      AwsError.unwrapOptionField("rebuildSnapshots", rebuildSnapshots)
    def getRestoreSnapshots
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Snapshot.ReadOnly]] =
      AwsError.unwrapOptionField("restoreSnapshots", restoreSnapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly {
    override val rebuildSnapshots
        : Optional[List[zio.aws.workspaces.model.Snapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rebuildSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Snapshot.wrap(item)
          }.toList
        )
    override val restoreSnapshots
        : Optional[List[zio.aws.workspaces.model.Snapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Snapshot.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse
  ): zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
