package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{IpGroupId, DirectoryId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateIpGroupsRequest(
    directoryId: DirectoryId,
    groupIds: Iterable[IpGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest = {
    import AssociateIpGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest
      .builder()
      .directoryId(DirectoryId.unwrap(directoryId): java.lang.String)
      .groupIds(groupIds.map { item =>
        IpGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.AssociateIpGroupsRequest.ReadOnly =
    zio.aws.workspaces.model.AssociateIpGroupsRequest.wrap(buildAwsValue())
}
object AssociateIpGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.AssociateIpGroupsRequest =
      zio.aws.workspaces.model.AssociateIpGroupsRequest(directoryId, groupIds)
    def directoryId: DirectoryId
    def groupIds: List[IpGroupId]
    def getDirectoryId: ZIO[Any, Nothing, DirectoryId] =
      ZIO.succeed(directoryId)
    def getGroupIds: ZIO[Any, Nothing, List[IpGroupId]] = ZIO.succeed(groupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest
  ) extends zio.aws.workspaces.model.AssociateIpGroupsRequest.ReadOnly {
    override val directoryId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.directoryId())
    override val groupIds: List[IpGroupId] = impl
      .groupIds()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.primitives.IpGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest
  ): zio.aws.workspaces.model.AssociateIpGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
