package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteClientBrandingRequest(
    resourceId: DirectoryId,
    platforms: Iterable[zio.aws.workspaces.model.ClientDeviceType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest = {
    import DeleteClientBrandingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .platformsWithStrings(platforms.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeleteClientBrandingRequest.ReadOnly =
    zio.aws.workspaces.model.DeleteClientBrandingRequest.wrap(buildAwsValue())
}
object DeleteClientBrandingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DeleteClientBrandingRequest =
      zio.aws.workspaces.model
        .DeleteClientBrandingRequest(resourceId, platforms)
    def resourceId: DirectoryId
    def platforms: List[zio.aws.workspaces.model.ClientDeviceType]
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getPlatforms
        : ZIO[Any, Nothing, List[zio.aws.workspaces.model.ClientDeviceType]] =
      ZIO.succeed(platforms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest
  ) extends zio.aws.workspaces.model.DeleteClientBrandingRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val platforms: List[zio.aws.workspaces.model.ClientDeviceType] =
      impl
        .platforms()
        .asScala
        .map { item =>
          zio.aws.workspaces.model.ClientDeviceType.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest
  ): zio.aws.workspaces.model.DeleteClientBrandingRequest.ReadOnly =
    new Wrapper(impl)
}
