package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{PaginationToken, Limit, DirectoryId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeWorkspaceDirectoriesRequest(
    directoryIds: Optional[Iterable[DirectoryId]] = Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest = {
    import DescribeWorkspaceDirectoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest
      .builder()
      .optionallyWith(
        directoryIds.map(value =>
          value.map { item =>
            DirectoryId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.directoryIds)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceDirectoriesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceDirectoriesRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceDirectoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspaceDirectoriesRequest =
      zio.aws.workspaces.model.DescribeWorkspaceDirectoriesRequest(
        directoryIds.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def directoryIds: Optional[List[DirectoryId]]
    def limit: Optional[Limit]
    def nextToken: Optional[PaginationToken]
    def getDirectoryIds: ZIO[Any, AwsError, List[DirectoryId]] =
      AwsError.unwrapOptionField("directoryIds", directoryIds)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspaceDirectoriesRequest.ReadOnly {
    override val directoryIds: Optional[List[DirectoryId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives.DirectoryId(item)
          }.toList
        )
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest
  ): zio.aws.workspaces.model.DescribeWorkspaceDirectoriesRequest.ReadOnly =
    new Wrapper(impl)
}
