package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  PaginationToken,
  Limit,
  NonEmptyString,
  ConnectionAliasId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeConnectionAliasesRequest(
    aliasIds: Optional[Iterable[ConnectionAliasId]] = Optional.Absent,
    resourceId: Optional[NonEmptyString] = Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest = {
    import DescribeConnectionAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
      .builder()
      .optionallyWith(
        aliasIds.map(value =>
          value.map { item =>
            ConnectionAliasId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aliasIds)
      .optionallyWith(
        resourceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectionAliasesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectionAliasesRequest
      .wrap(buildAwsValue())
}
object DescribeConnectionAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeConnectionAliasesRequest =
      zio.aws.workspaces.model.DescribeConnectionAliasesRequest(
        aliasIds.map(value => value),
        resourceId.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def aliasIds: Optional[List[ConnectionAliasId]]
    def resourceId: Optional[NonEmptyString]
    def limit: Optional[Limit]
    def nextToken: Optional[PaginationToken]
    def getAliasIds: ZIO[Any, AwsError, List[ConnectionAliasId]] =
      AwsError.unwrapOptionField("aliasIds", aliasIds)
    def getResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
  ) extends zio.aws.workspaces.model.DescribeConnectionAliasesRequest.ReadOnly {
    override val aliasIds: Optional[List[ConnectionAliasId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliasIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives.ConnectionAliasId(item)
          }.toList
        )
    override val resourceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
  ): zio.aws.workspaces.model.DescribeConnectionAliasesRequest.ReadOnly =
    new Wrapper(impl)
}
