package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientProperties(
    reconnectEnabled: Optional[zio.aws.workspaces.model.ReconnectEnum] =
      Optional.Absent,
    logUploadEnabled: Optional[zio.aws.workspaces.model.LogUploadEnum] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ClientProperties = {
    import ClientProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ClientProperties
      .builder()
      .optionallyWith(reconnectEnabled.map(value => value.unwrap))(
        _.reconnectEnabled
      )
      .optionallyWith(logUploadEnabled.map(value => value.unwrap))(
        _.logUploadEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ClientProperties.ReadOnly =
    zio.aws.workspaces.model.ClientProperties.wrap(buildAwsValue())
}
object ClientProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ClientProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ClientProperties =
      zio.aws.workspaces.model.ClientProperties(
        reconnectEnabled.map(value => value),
        logUploadEnabled.map(value => value)
      )
    def reconnectEnabled: Optional[zio.aws.workspaces.model.ReconnectEnum]
    def logUploadEnabled: Optional[zio.aws.workspaces.model.LogUploadEnum]
    def getReconnectEnabled
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("reconnectEnabled", reconnectEnabled)
    def getLogUploadEnabled
        : ZIO[Any, AwsError, zio.aws.workspaces.model.LogUploadEnum] =
      AwsError.unwrapOptionField("logUploadEnabled", logUploadEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ClientProperties
  ) extends zio.aws.workspaces.model.ClientProperties.ReadOnly {
    override val reconnectEnabled
        : Optional[zio.aws.workspaces.model.ReconnectEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reconnectEnabled())
        .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val logUploadEnabled
        : Optional[zio.aws.workspaces.model.LogUploadEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logUploadEnabled())
        .map(value => zio.aws.workspaces.model.LogUploadEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ClientProperties
  ): zio.aws.workspaces.model.ClientProperties.ReadOnly = new Wrapper(impl)
}
