package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  SecurityGroupId,
  DefaultOu,
  BooleanObject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WorkspaceCreationProperties(
    enableWorkDocs: Optional[BooleanObject] = Optional.Absent,
    enableInternetAccess: Optional[BooleanObject] = Optional.Absent,
    defaultOu: Optional[DefaultOu] = Optional.Absent,
    customSecurityGroupId: Optional[SecurityGroupId] = Optional.Absent,
    userEnabledAsLocalAdministrator: Optional[BooleanObject] = Optional.Absent,
    enableMaintenanceMode: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceCreationProperties = {
    import WorkspaceCreationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceCreationProperties
      .builder()
      .optionallyWith(enableWorkDocs.map(value => value: java.lang.Boolean))(
        _.enableWorkDocs
      )
      .optionallyWith(
        enableInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableInternetAccess)
      .optionallyWith(
        defaultOu.map(value => DefaultOu.unwrap(value): java.lang.String)
      )(_.defaultOu)
      .optionallyWith(
        customSecurityGroupId.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.customSecurityGroupId)
      .optionallyWith(
        userEnabledAsLocalAdministrator.map(value => value: java.lang.Boolean)
      )(_.userEnabledAsLocalAdministrator)
      .optionallyWith(
        enableMaintenanceMode.map(value => value: java.lang.Boolean)
      )(_.enableMaintenanceMode)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.WorkspaceCreationProperties.ReadOnly =
    zio.aws.workspaces.model.WorkspaceCreationProperties.wrap(buildAwsValue())
}
object WorkspaceCreationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceCreationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceCreationProperties =
      zio.aws.workspaces.model.WorkspaceCreationProperties(
        enableWorkDocs.map(value => value),
        enableInternetAccess.map(value => value),
        defaultOu.map(value => value),
        customSecurityGroupId.map(value => value),
        userEnabledAsLocalAdministrator.map(value => value),
        enableMaintenanceMode.map(value => value)
      )
    def enableWorkDocs: Optional[BooleanObject]
    def enableInternetAccess: Optional[BooleanObject]
    def defaultOu: Optional[DefaultOu]
    def customSecurityGroupId: Optional[SecurityGroupId]
    def userEnabledAsLocalAdministrator: Optional[BooleanObject]
    def enableMaintenanceMode: Optional[BooleanObject]
    def getEnableWorkDocs: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enableWorkDocs", enableWorkDocs)
    def getEnableInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enableInternetAccess", enableInternetAccess)
    def getDefaultOu: ZIO[Any, AwsError, DefaultOu] =
      AwsError.unwrapOptionField("defaultOu", defaultOu)
    def getCustomSecurityGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("customSecurityGroupId", customSecurityGroupId)
    def getUserEnabledAsLocalAdministrator: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "userEnabledAsLocalAdministrator",
        userEnabledAsLocalAdministrator
      )
    def getEnableMaintenanceMode: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enableMaintenanceMode", enableMaintenanceMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceCreationProperties
  ) extends zio.aws.workspaces.model.WorkspaceCreationProperties.ReadOnly {
    override val enableWorkDocs: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.enableWorkDocs())
      .map(value => value: BooleanObject)
    override val enableInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableInternetAccess())
        .map(value => value: BooleanObject)
    override val defaultOu: Optional[DefaultOu] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultOu())
      .map(value => zio.aws.workspaces.model.primitives.DefaultOu(value))
    override val customSecurityGroupId: Optional[SecurityGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customSecurityGroupId())
        .map(value =>
          zio.aws.workspaces.model.primitives.SecurityGroupId(value)
        )
    override val userEnabledAsLocalAdministrator: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userEnabledAsLocalAdministrator())
        .map(value => value: BooleanObject)
    override val enableMaintenanceMode: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableMaintenanceMode())
        .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceCreationProperties
  ): zio.aws.workspaces.model.WorkspaceCreationProperties.ReadOnly =
    new Wrapper(impl)
}
