package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  ClientLoginMessage,
  ClientLocale,
  ClientEmail,
  ClientUrl
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IosClientBrandingAttributes(
    logoUrl: Optional[ClientUrl] = Optional.Absent,
    logo2xUrl: Optional[ClientUrl] = Optional.Absent,
    logo3xUrl: Optional[ClientUrl] = Optional.Absent,
    supportEmail: Optional[ClientEmail] = Optional.Absent,
    supportLink: Optional[ClientUrl] = Optional.Absent,
    forgotPasswordLink: Optional[ClientUrl] = Optional.Absent,
    loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.IosClientBrandingAttributes = {
    import IosClientBrandingAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.IosClientBrandingAttributes
      .builder()
      .optionallyWith(
        logoUrl.map(value => ClientUrl.unwrap(value): java.lang.String)
      )(_.logoUrl)
      .optionallyWith(
        logo2xUrl.map(value => ClientUrl.unwrap(value): java.lang.String)
      )(_.logo2xUrl)
      .optionallyWith(
        logo3xUrl.map(value => ClientUrl.unwrap(value): java.lang.String)
      )(_.logo3xUrl)
      .optionallyWith(
        supportEmail.map(value => ClientEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportLink.map(value => ClientUrl.unwrap(value): java.lang.String)
      )(_.supportLink)
      .optionallyWith(
        forgotPasswordLink.map(value =>
          ClientUrl.unwrap(value): java.lang.String
        )
      )(_.forgotPasswordLink)
      .optionallyWith(
        loginMessage.map(value =>
          value
            .map({ case (key, value) =>
              (ClientLocale
                .unwrap(key): java.lang.String) -> (ClientLoginMessage
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.loginMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.IosClientBrandingAttributes.ReadOnly =
    zio.aws.workspaces.model.IosClientBrandingAttributes.wrap(buildAwsValue())
}
object IosClientBrandingAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.IosClientBrandingAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.IosClientBrandingAttributes =
      zio.aws.workspaces.model.IosClientBrandingAttributes(
        logoUrl.map(value => value),
        logo2xUrl.map(value => value),
        logo3xUrl.map(value => value),
        supportEmail.map(value => value),
        supportLink.map(value => value),
        forgotPasswordLink.map(value => value),
        loginMessage.map(value => value)
      )
    def logoUrl: Optional[ClientUrl]
    def logo2xUrl: Optional[ClientUrl]
    def logo3xUrl: Optional[ClientUrl]
    def supportEmail: Optional[ClientEmail]
    def supportLink: Optional[ClientUrl]
    def forgotPasswordLink: Optional[ClientUrl]
    def loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]]
    def getLogoUrl: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("logoUrl", logoUrl)
    def getLogo2xUrl: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("logo2xUrl", logo2xUrl)
    def getLogo3xUrl: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("logo3xUrl", logo3xUrl)
    def getSupportEmail: ZIO[Any, AwsError, ClientEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportLink: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("supportLink", supportLink)
    def getForgotPasswordLink: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("forgotPasswordLink", forgotPasswordLink)
    def getLoginMessage
        : ZIO[Any, AwsError, Map[ClientLocale, ClientLoginMessage]] =
      AwsError.unwrapOptionField("loginMessage", loginMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.IosClientBrandingAttributes
  ) extends zio.aws.workspaces.model.IosClientBrandingAttributes.ReadOnly {
    override val logoUrl: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.logoUrl())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val logo2xUrl: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.logo2xUrl())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val logo3xUrl: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.logo3xUrl())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val supportEmail: Optional[ClientEmail] = zio.aws.core.internal
      .optionalFromNullable(impl.supportEmail())
      .map(value => zio.aws.workspaces.model.primitives.ClientEmail(value))
    override val supportLink: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.supportLink())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val forgotPasswordLink: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.forgotPasswordLink())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loginMessage())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.workspaces.model.primitives.ClientLocale(
                key
              ) -> zio.aws.workspaces.model.primitives.ClientLoginMessage(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.IosClientBrandingAttributes
  ): zio.aws.workspaces.model.IosClientBrandingAttributes.ReadOnly =
    new Wrapper(impl)
}
