package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait WorkspaceState {
  def unwrap: software.amazon.awssdk.services.workspaces.model.WorkspaceState
}
object WorkspaceState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkspaceState
  ): zio.aws.workspaces.model.WorkspaceState = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.IMPAIRED =>
      val r = IMPAIRED
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.REBOOTING =>
      val r = REBOOTING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.REBUILDING =>
      val r = REBUILDING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.RESTORING =>
      val r = RESTORING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.MAINTENANCE =>
      val r = MAINTENANCE
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.ADMIN_MAINTENANCE =>
      val r = ADMIN_MAINTENANCE
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.PENDING
  }
  case object AVAILABLE extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.AVAILABLE
  }
  case object IMPAIRED extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.IMPAIRED
  }
  case object UNHEALTHY extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.UNHEALTHY
  }
  case object REBOOTING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.REBOOTING
  }
  case object STARTING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.STARTING
  }
  case object REBUILDING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.REBUILDING
  }
  case object RESTORING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.RESTORING
  }
  case object MAINTENANCE extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.MAINTENANCE
  }
  case object ADMIN_MAINTENANCE
      extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.ADMIN_MAINTENANCE
  }
  case object TERMINATING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.TERMINATING
  }
  case object TERMINATED extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.TERMINATED
  }
  case object SUSPENDED extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.SUSPENDED
  }
  case object UPDATING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.UPDATING
  }
  case object STOPPING extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.STOPPING
  }
  case object STOPPED extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.STOPPED
  }
  case object ERROR extends zio.aws.workspaces.model.WorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceState.ERROR
  }
}
