package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait WorkspaceDirectoryType {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType
}
object WorkspaceDirectoryType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType
  ): zio.aws.workspaces.model.WorkspaceDirectoryType = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType.SIMPLE_AD =>
      val r = SIMPLE_AD
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType.AD_CONNECTOR =>
      val r = AD_CONNECTOR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkspaceDirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType.UNKNOWN_TO_SDK_VERSION
  }
  case object SIMPLE_AD
      extends zio.aws.workspaces.model.WorkspaceDirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType.SIMPLE_AD
  }
  case object AD_CONNECTOR
      extends zio.aws.workspaces.model.WorkspaceDirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType =
      software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType.AD_CONNECTOR
  }
}
