package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreWorkspaceRequest(workspaceId: WorkspaceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest = {
    import RestoreWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RestoreWorkspaceRequest.ReadOnly =
    zio.aws.workspaces.model.RestoreWorkspaceRequest.wrap(buildAwsValue())
}
object RestoreWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RestoreWorkspaceRequest =
      zio.aws.workspaces.model.RestoreWorkspaceRequest(workspaceId)
    def workspaceId: WorkspaceId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest
  ) extends zio.aws.workspaces.model.RestoreWorkspaceRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest
  ): zio.aws.workspaces.model.RestoreWorkspaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
