package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportWorkspaceImageResponse(
    imageId: Optional[WorkspaceImageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse = {
    import ImportWorkspaceImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse
      .builder()
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly =
    zio.aws.workspaces.model.ImportWorkspaceImageResponse.wrap(buildAwsValue())
}
object ImportWorkspaceImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ImportWorkspaceImageResponse =
      zio.aws.workspaces.model
        .ImportWorkspaceImageResponse(imageId.map(value => value))
    def imageId: Optional[WorkspaceImageId]
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse
  ) extends zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly {
    override val imageId: Optional[WorkspaceImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse
  ): zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly =
    new Wrapper(impl)
}
