package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{Limit, PaginationToken, IpGroupId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeIpGroupsRequest(
    groupIds: Optional[Iterable[IpGroupId]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[Limit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest = {
    import DescribeIpGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest
      .builder()
      .optionallyWith(
        groupIds.map(value =>
          value.map { item =>
            IpGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupIds)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeIpGroupsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeIpGroupsRequest.wrap(buildAwsValue())
}
object DescribeIpGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeIpGroupsRequest =
      zio.aws.workspaces.model.DescribeIpGroupsRequest(
        groupIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def groupIds: Optional[List[IpGroupId]]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[Limit]
    def getGroupIds: ZIO[Any, AwsError, List[IpGroupId]] =
      AwsError.unwrapOptionField("groupIds", groupIds)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest
  ) extends zio.aws.workspaces.model.DescribeIpGroupsRequest.ReadOnly {
    override val groupIds: Optional[List[IpGroupId]] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.IpGroupId(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
    override val maxResults: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest
  ): zio.aws.workspaces.model.DescribeIpGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
