package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeWorkspaceImagesResponse(
    images: Optional[Iterable[zio.aws.workspaces.model.WorkspaceImage]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse = {
    import DescribeWorkspaceImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
      .builder()
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceImagesResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspaceImagesResponse =
      zio.aws.workspaces.model.DescribeWorkspaceImagesResponse(
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def images: Optional[List[zio.aws.workspaces.model.WorkspaceImage.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getImages: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkspaceImage.ReadOnly
    ]] = AwsError.unwrapOptionField("images", images)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly {
    override val images
        : Optional[List[zio.aws.workspaces.model.WorkspaceImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.images())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.WorkspaceImage.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
  ): zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly =
    new Wrapper(impl)
}
