package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  AwsAccount,
  ConnectionAliasId,
  ConnectionString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectionAlias(
    connectionString: Optional[ConnectionString] = Optional.Absent,
    aliasId: Optional[ConnectionAliasId] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.ConnectionAliasState] =
      Optional.Absent,
    ownerAccountId: Optional[AwsAccount] = Optional.Absent,
    associations: Optional[
      Iterable[zio.aws.workspaces.model.ConnectionAliasAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ConnectionAlias = {
    import ConnectionAlias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ConnectionAlias
      .builder()
      .optionallyWith(
        connectionString.map(value =>
          ConnectionString.unwrap(value): java.lang.String
        )
      )(_.connectionString)
      .optionallyWith(
        aliasId.map(value => ConnectionAliasId.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        ownerAccountId.map(value => AwsAccount.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ConnectionAlias.ReadOnly =
    zio.aws.workspaces.model.ConnectionAlias.wrap(buildAwsValue())
}
object ConnectionAlias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ConnectionAlias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ConnectionAlias =
      zio.aws.workspaces.model.ConnectionAlias(
        connectionString.map(value => value),
        aliasId.map(value => value),
        state.map(value => value),
        ownerAccountId.map(value => value),
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionString: Optional[ConnectionString]
    def aliasId: Optional[ConnectionAliasId]
    def state: Optional[zio.aws.workspaces.model.ConnectionAliasState]
    def ownerAccountId: Optional[AwsAccount]
    def associations: Optional[
      List[zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly]
    ]
    def getConnectionString: ZIO[Any, AwsError, ConnectionString] =
      AwsError.unwrapOptionField("connectionString", connectionString)
    def getAliasId: ZIO[Any, AwsError, ConnectionAliasId] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ConnectionAliasState] =
      AwsError.unwrapOptionField("state", state)
    def getOwnerAccountId: ZIO[Any, AwsError, AwsAccount] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAlias
  ) extends zio.aws.workspaces.model.ConnectionAlias.ReadOnly {
    override val connectionString: Optional[ConnectionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionString())
        .map(value =>
          zio.aws.workspaces.model.primitives.ConnectionString(value)
        )
    override val aliasId: Optional[ConnectionAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasId())
      .map(value =>
        zio.aws.workspaces.model.primitives.ConnectionAliasId(value)
      )
    override val state
        : Optional[zio.aws.workspaces.model.ConnectionAliasState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.ConnectionAliasState.wrap(value))
    override val ownerAccountId: Optional[AwsAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value => zio.aws.workspaces.model.primitives.AwsAccount(value))
    override val associations: Optional[
      List[zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.ConnectionAliasAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAlias
  ): zio.aws.workspaces.model.ConnectionAlias.ReadOnly = new Wrapper(impl)
}
