package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  AddInUrl,
  AddInName,
  DirectoryId,
  AmazonUuid
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectClientAddIn(
    addInId: Optional[AmazonUuid] = Optional.Absent,
    resourceId: Optional[DirectoryId] = Optional.Absent,
    name: Optional[AddInName] = Optional.Absent,
    url: Optional[AddInUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn = {
    import ConnectClientAddIn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
      .builder()
      .optionallyWith(
        addInId.map(value => AmazonUuid.unwrap(value): java.lang.String)
      )(_.addInId)
      .optionallyWith(
        resourceId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        name.map(value => AddInName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        url.map(value => AddInUrl.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly =
    zio.aws.workspaces.model.ConnectClientAddIn.wrap(buildAwsValue())
}
object ConnectClientAddIn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ConnectClientAddIn =
      zio.aws.workspaces.model.ConnectClientAddIn(
        addInId.map(value => value),
        resourceId.map(value => value),
        name.map(value => value),
        url.map(value => value)
      )
    def addInId: Optional[AmazonUuid]
    def resourceId: Optional[DirectoryId]
    def name: Optional[AddInName]
    def url: Optional[AddInUrl]
    def getAddInId: ZIO[Any, AwsError, AmazonUuid] =
      AwsError.unwrapOptionField("addInId", addInId)
    def getResourceId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getName: ZIO[Any, AwsError, AddInName] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, AddInUrl] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
  ) extends zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly {
    override val addInId: Optional[AmazonUuid] = zio.aws.core.internal
      .optionalFromNullable(impl.addInId())
      .map(value => zio.aws.workspaces.model.primitives.AmazonUuid(value))
    override val resourceId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val name: Optional[AddInName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workspaces.model.primitives.AddInName(value))
    override val url: Optional[AddInUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.workspaces.model.primitives.AddInUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
  ): zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly = new Wrapper(impl)
}
