package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TerminateWorkspacesResponse(
    failedRequests: Optional[
      Iterable[zio.aws.workspaces.model.FailedWorkspaceChangeRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse = {
    import TerminateWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse
      .builder()
      .optionallyWith(
        failedRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedRequests)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly =
    zio.aws.workspaces.model.TerminateWorkspacesResponse.wrap(buildAwsValue())
}
object TerminateWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.TerminateWorkspacesResponse =
      zio.aws.workspaces.model.TerminateWorkspacesResponse(
        failedRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedRequests: Optional[
      List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly]
    ]
    def getFailedRequests: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("failedRequests", failedRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse
  ) extends zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly {
    override val failedRequests: Optional[
      List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.FailedWorkspaceChangeRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse
  ): zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly =
    new Wrapper(impl)
}
