package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.IpGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AuthorizeIpRulesRequest(
    groupId: IpGroupId,
    userRules: Iterable[zio.aws.workspaces.model.IpRuleItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest = {
    import AuthorizeIpRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest
      .builder()
      .groupId(IpGroupId.unwrap(groupId): java.lang.String)
      .userRules(userRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.AuthorizeIpRulesRequest.ReadOnly =
    zio.aws.workspaces.model.AuthorizeIpRulesRequest.wrap(buildAwsValue())
}
object AuthorizeIpRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.AuthorizeIpRulesRequest =
      zio.aws.workspaces.model.AuthorizeIpRulesRequest(
        groupId,
        userRules.map { item =>
          item.asEditable
        }
      )
    def groupId: IpGroupId
    def userRules: List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]
    def getGroupId: ZIO[Any, Nothing, IpGroupId] = ZIO.succeed(groupId)
    def getUserRules: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.IpRuleItem.ReadOnly
    ]] = ZIO.succeed(userRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest
  ) extends zio.aws.workspaces.model.AuthorizeIpRulesRequest.ReadOnly {
    override val groupId: IpGroupId =
      zio.aws.workspaces.model.primitives.IpGroupId(impl.groupId())
    override val userRules: List[zio.aws.workspaces.model.IpRuleItem.ReadOnly] =
      impl
        .userRules()
        .asScala
        .map { item =>
          zio.aws.workspaces.model.IpRuleItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest
  ): zio.aws.workspaces.model.AuthorizeIpRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
