package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait AssociationStatus {
  def unwrap: software.amazon.awssdk.services.workspaces.model.AssociationStatus
}
object AssociationStatus {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.AssociationStatus
  ): zio.aws.workspaces.model.AssociationStatus = value match {
    case software.amazon.awssdk.services.workspaces.model.AssociationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationStatus.NOT_ASSOCIATED =>
      val r = NOT_ASSOCIATED
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationStatus.ASSOCIATED_WITH_OWNER_ACCOUNT =>
      val r = ASSOCIATED_WITH_OWNER_ACCOUNT
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationStatus.ASSOCIATED_WITH_SHARED_ACCOUNT =>
      val r = ASSOCIATED_WITH_SHARED_ACCOUNT
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationStatus.PENDING_ASSOCIATION =>
      val r = PENDING_ASSOCIATION
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationStatus.PENDING_DISASSOCIATION =>
      val r = PENDING_DISASSOCIATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationStatus =
      software.amazon.awssdk.services.workspaces.model.AssociationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_ASSOCIATED
      extends zio.aws.workspaces.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationStatus =
      software.amazon.awssdk.services.workspaces.model.AssociationStatus.NOT_ASSOCIATED
  }
  case object ASSOCIATED_WITH_OWNER_ACCOUNT
      extends zio.aws.workspaces.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationStatus =
      software.amazon.awssdk.services.workspaces.model.AssociationStatus.ASSOCIATED_WITH_OWNER_ACCOUNT
  }
  case object ASSOCIATED_WITH_SHARED_ACCOUNT
      extends zio.aws.workspaces.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationStatus =
      software.amazon.awssdk.services.workspaces.model.AssociationStatus.ASSOCIATED_WITH_SHARED_ACCOUNT
  }
  case object PENDING_ASSOCIATION
      extends zio.aws.workspaces.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationStatus =
      software.amazon.awssdk.services.workspaces.model.AssociationStatus.PENDING_ASSOCIATION
  }
  case object PENDING_DISASSOCIATION
      extends zio.aws.workspaces.model.AssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationStatus =
      software.amazon.awssdk.services.workspaces.model.AssociationStatus.PENDING_DISASSOCIATION
  }
}
