package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.ConnectionAliasId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateConnectionAliasPermissionRequest(
    aliasId: ConnectionAliasId,
    connectionAliasPermission: zio.aws.workspaces.model.ConnectionAliasPermission
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest = {
    import UpdateConnectionAliasPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest
      .builder()
      .aliasId(ConnectionAliasId.unwrap(aliasId): java.lang.String)
      .connectionAliasPermission(connectionAliasPermission.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.UpdateConnectionAliasPermissionRequest.ReadOnly =
    zio.aws.workspaces.model.UpdateConnectionAliasPermissionRequest
      .wrap(buildAwsValue())
}
object UpdateConnectionAliasPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.UpdateConnectionAliasPermissionRequest =
      zio.aws.workspaces.model.UpdateConnectionAliasPermissionRequest(
        aliasId,
        connectionAliasPermission.asEditable
      )
    def aliasId: ConnectionAliasId
    def connectionAliasPermission
        : zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
    def getAliasId: ZIO[Any, Nothing, ConnectionAliasId] = ZIO.succeed(aliasId)
    def getConnectionAliasPermission: ZIO[
      Any,
      Nothing,
      zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
    ] = ZIO.succeed(connectionAliasPermission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest
  ) extends zio.aws.workspaces.model.UpdateConnectionAliasPermissionRequest.ReadOnly {
    override val aliasId: ConnectionAliasId =
      zio.aws.workspaces.model.primitives.ConnectionAliasId(impl.aliasId())
    override val connectionAliasPermission
        : zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly =
      zio.aws.workspaces.model.ConnectionAliasPermission
        .wrap(impl.connectionAliasPermission())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest
  ): zio.aws.workspaces.model.UpdateConnectionAliasPermissionRequest.ReadOnly =
    new Wrapper(impl)
}
