package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyClientPropertiesRequest(
    resourceId: NonEmptyString,
    clientProperties: zio.aws.workspaces.model.ClientProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest = {
    import ModifyClientPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest
      .builder()
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .clientProperties(clientProperties.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifyClientPropertiesRequest.ReadOnly =
    zio.aws.workspaces.model.ModifyClientPropertiesRequest.wrap(buildAwsValue())
}
object ModifyClientPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ModifyClientPropertiesRequest =
      zio.aws.workspaces.model
        .ModifyClientPropertiesRequest(resourceId, clientProperties.asEditable)
    def resourceId: NonEmptyString
    def clientProperties: zio.aws.workspaces.model.ClientProperties.ReadOnly
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getClientProperties: ZIO[
      Any,
      Nothing,
      zio.aws.workspaces.model.ClientProperties.ReadOnly
    ] = ZIO.succeed(clientProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest
  ) extends zio.aws.workspaces.model.ModifyClientPropertiesRequest.ReadOnly {
    override val resourceId: NonEmptyString =
      zio.aws.workspaces.model.primitives.NonEmptyString(impl.resourceId())
    override val clientProperties
        : zio.aws.workspaces.model.ClientProperties.ReadOnly =
      zio.aws.workspaces.model.ClientProperties.wrap(impl.clientProperties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest
  ): zio.aws.workspaces.model.ModifyClientPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
