package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionAliasState {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.ConnectionAliasState
}
object ConnectionAliasState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ConnectionAliasState
  ): zio.aws.workspaces.model.ConnectionAliasState = value match {
    case software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.ConnectionAliasState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionAliasState =
      software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.workspaces.model.ConnectionAliasState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionAliasState =
      software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.CREATING
  }
  case object CREATED extends zio.aws.workspaces.model.ConnectionAliasState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionAliasState =
      software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.CREATED
  }
  case object DELETING extends zio.aws.workspaces.model.ConnectionAliasState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionAliasState =
      software.amazon.awssdk.services.workspaces.model.ConnectionAliasState.DELETING
  }
}
