package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  AddInUrl,
  AddInName,
  DirectoryId,
  AmazonUuid
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateConnectClientAddInRequest(
    addInId: AmazonUuid,
    resourceId: DirectoryId,
    name: Optional[AddInName] = Optional.Absent,
    url: Optional[AddInUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest = {
    import UpdateConnectClientAddInRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest
      .builder()
      .addInId(AmazonUuid.unwrap(addInId): java.lang.String)
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        name.map(value => AddInName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        url.map(value => AddInUrl.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.UpdateConnectClientAddInRequest.ReadOnly =
    zio.aws.workspaces.model.UpdateConnectClientAddInRequest
      .wrap(buildAwsValue())
}
object UpdateConnectClientAddInRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.UpdateConnectClientAddInRequest =
      zio.aws.workspaces.model.UpdateConnectClientAddInRequest(
        addInId,
        resourceId,
        name.map(value => value),
        url.map(value => value)
      )
    def addInId: AmazonUuid
    def resourceId: DirectoryId
    def name: Optional[AddInName]
    def url: Optional[AddInUrl]
    def getAddInId: ZIO[Any, Nothing, AmazonUuid] = ZIO.succeed(addInId)
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getName: ZIO[Any, AwsError, AddInName] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, AddInUrl] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest
  ) extends zio.aws.workspaces.model.UpdateConnectClientAddInRequest.ReadOnly {
    override val addInId: AmazonUuid =
      zio.aws.workspaces.model.primitives.AmazonUuid(impl.addInId())
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val name: Optional[AddInName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workspaces.model.primitives.AddInName(value))
    override val url: Optional[AddInUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.workspaces.model.primitives.AddInUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest
  ): zio.aws.workspaces.model.UpdateConnectClientAddInRequest.ReadOnly =
    new Wrapper(impl)
}
