package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait OperatingSystemType {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.OperatingSystemType
}
object OperatingSystemType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.OperatingSystemType
  ): zio.aws.workspaces.model.OperatingSystemType = value match {
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemType.WINDOWS =>
      val r = WINDOWS
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemType.LINUX =>
      val r = LINUX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.OperatingSystemType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemType =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemType.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS extends zio.aws.workspaces.model.OperatingSystemType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemType =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemType.WINDOWS
  }
  case object LINUX extends zio.aws.workspaces.model.OperatingSystemType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemType =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemType.LINUX
  }
}
