package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyWorkspaceStateRequest(
    workspaceId: WorkspaceId,
    workspaceState: zio.aws.workspaces.model.TargetWorkspaceState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest = {
    import ModifyWorkspaceStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .workspaceState(workspaceState.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifyWorkspaceStateRequest.ReadOnly =
    zio.aws.workspaces.model.ModifyWorkspaceStateRequest.wrap(buildAwsValue())
}
object ModifyWorkspaceStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ModifyWorkspaceStateRequest =
      zio.aws.workspaces.model
        .ModifyWorkspaceStateRequest(workspaceId, workspaceState)
    def workspaceId: WorkspaceId
    def workspaceState: zio.aws.workspaces.model.TargetWorkspaceState
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getWorkspaceState
        : ZIO[Any, Nothing, zio.aws.workspaces.model.TargetWorkspaceState] =
      ZIO.succeed(workspaceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest
  ) extends zio.aws.workspaces.model.ModifyWorkspaceStateRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
    override val workspaceState: zio.aws.workspaces.model.TargetWorkspaceState =
      zio.aws.workspaces.model.TargetWorkspaceState.wrap(impl.workspaceState())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest
  ): zio.aws.workspaces.model.ModifyWorkspaceStateRequest.ReadOnly =
    new Wrapper(impl)
}
